function [gamc]=Complete(gamma, pm,nDum);
% Complete: computes the full vector gamma
%*****************************************
% INPUTS:
% gamma: vector with only one component for a group of variables
%         that have to be treated together.
% pm   : number of independent effects
% nDum : vector of number of dummies variables in each group
%
% OUTPUT:
% gamc : full vector gamma (of size p)
%
% NOTES called by gofg_sp, probord and pbvs_sp
%
%REFERENCE:
% Delouille,V., Bayesian variable selection with related predictors,
% MSc thesis, University of Kent at Canterbury, UK, 1998.
%
%Copyright (c) 1998 Veronique Delouille.
%******************************************
[niter,pg]=size(gamma);
gam1=gamma(:,1:pm);
gam2=gamma(:,pm+1:pg);
lnDum=length(nDum);
gam2c=zeros(niter,sum(nDum));
lold=0;
for i=1:lnDum
	oned=ones(1,nDum(i));
	lnew=lold + nDum(i);
	gam2c(:,lold+1:lnew)=gam2(:,i)*oned;
	lold = lnew;
end

gamc = [gam1 gam2c];
