function [prog]=priormef(gamma,w,pm,nDum)
% priormef: Function that computes the log-prior probability of gamma,
%           Grouping principle.
%********************************************************************
%INPUTS:
%       gamma,  binary vector (reduced version)
%       w,      Bernoulli prior
%               w(1) is for the independent effects
%               the scalars w(2:lnDum+1) are for the grouped variables.
% 
%OUTPUT:
%       prog,   log-prior of gamma
%
%REFERENCE:
% Delouille,V., Bayesian variable selection with related predictors,
% MSc thesis, University of Kent at Canterbury, UK, 1998.

%Copyright (c) 1998 Veronique Delouille.
%**********************************************************************
%Compute prior for independent effects
wm=w(1);
gam1=gamma(1:pm);
prog1=sum(log((wm.^gam1).*(1-wm).^(1-gam1)));

%compute prior for dummy var
prog2=0;
lnDum=length(nDum);
gam2=gamma(pm+1:pm+lnDum);

for i=1:lnDum
	wi=w(1+i);
	gami=gam2(i);
	prog2=prog2+ log((wi.^gami).*(1-wi).^(1-gami));
end;

prog=prog1+prog2;
