function [gamc]=Complete(gamma, inde,nDum,pm);
% Complete : gives the vector gamma with p components
%****************************************************
% INPUTS:
% gamma: matrix with only one component for a group of variables
%	 that have to be treated together.
% inde : number of independent effects
% nDum : vector which gives the number of variables in each group 
% pm   : number of independent main effects
%
% OUTPUTS:
% gamc : full vector gamma (of size p)
%
% NOTES : 
% Called by  gofg_sp, pbvs_spgi.m and probord.m 
% The order in gamma must be :
% [X1..Xpm X1^2 X1X2...Xpm^2 D1,...,Dr,D1.X1, ... ,D1.Xpm,...,
% Dr.X1..Dr.Xpm], where D1,...Dr are r groups of variable.
%
%REFERENCE:
% Delouille,V., Bayesian variable selection with related predictors, 
% MSc thesis, University of Kent at Canterbury, UK, 1998.
%
% Copyright (c) 1998 Veronique Delouille
%******************************************************************

[niter,ltot]=size(gamma);
% Separete quantitative and dummy variable
gamma=full(gamma);
gamQ=gamma(:,1:inde);%'independent' effects --- no problems.
gamD=gamma(:,inde+1: ltot);
lnDum=length(nDum);
%
% separate main effects and interaction in GamD
%
gamD1=gamD(:,1:lnDum);
colgamD=size(gamD,2);
gamD2=gamD(:,lnDum +1:colgamD);
%
% Change from 'short gamD' to 'complete' gamD
%
snDum=sum(nDum);
gamD1c=zeros(niter,snDum);
gamD2c=zeros(niter,pm*snDum);
lold=0;
lold2=0;
for i=1:lnDum
% Deal with main effects.
	oned=ones(1,nDum(i));
	lnew=lold + nDum(i);
	gamD1c(:,lold+1:lnew)=gamD1(:,i)*oned;
	lold = lnew;
% Deal with interactions.
	lnew2=lold2 +pm*nDum(i);
	% take all interactions Di with X1,..Xpm
	gamD2i=gamD2(:,((i-1)*pm +1) : i*pm);
	developped=kron(gamD2i,oned);
	gamD2c(:,lold2+1 : lnew2)=developped;
	lold2=lnew2;
end

% Put everything together.
gamc = sparse([gamQ gamD1c gamD2c]);
