function [gprod]=gamprod(gam1,l)
% gamprod : products of components of gamma related to main effects
%******************************************************************
% INPUTS: 
% gam1  :vector gamma of main effects
% l     :length of vector gamma for independent effects
%
% OUTPUTS: 
% gprod : vector of length (l-pm) containing the products g1g1,g1g2,...
%
% REFERENCE:
% Delouille,V., Bayesian variable selection with related predictors,
% MSc thesis, University of Kent at Canterbury, UK, 1998.
%
% Copyright (c) 1998 Veronique Delouille
%*******************************************************************

pm=length(gam1);
lprod=l-pm;
GG=gam1'*gam1; %pm x pm matrix of all products of gam1;
gp=zeros(1,lprod);
lold=0;
lnew=0;

for i=1:pm
   rowi=GG(i,i:pm);
   lnew=length(rowi)+lold;
   gp(lold+1:lnew)=rowi;
   lold=lnew;
end;

gprod=gp;
