function [gsum]=gamsumD(gamD1,gamQm,lnDum)
% gamprod : sums of components of gamma related to independent 
%           main effects and groups of variables
%******************************************************************
% INPUTS:
%       gamD1,  gamma for the main effects of grouped variables
%       gamQm,  gamma for the main effects of quantitative variables
%       lnDum,  number of distinct groups of variables
% OUTPUT
%       gsum,   [gX1 + gD1,gX2+gD1,...]
%
% REFERENCE:
% Delouille,V., Bayesian variable selection with related predictors,
% MSc thesis, University of Kent at Canterbury, UK, 1998.
%
% Copyright (c) 1998 Veronique Delouille
%*******************************************************************
pm=length(gamQm);
gs=[];
for i=1:lnDum
	Di=gamD1(i)*ones(1,pm);
	gs=cat(2,gs,gamQm+Di);
end
gsum=gs;


