function [r, Qqr, Rqr]= ...
gofg_sp(gamma,indice,X,Ytilde,QqrP,RqrP,elem,k,delta,w,v1,inde,nDum,pm);

%gofg_sp: Selection prior - Function that
%         computes the log-relative posterior probability
%	  Models with interactions and  grouped variables.
%*******************************************************************
% INPUTS:
% gamma,          binary vector
% indice,         1 -- QR decomp
%                 2 -- QRinsert
%                 3 -- QRdelete
% X, 		  independent variables, n by p
% Ytilde,         augmented response matrix, (n+p) by q
% QqrP,RqrP,      QR-matrices of the previous vector
% elem,           position to add/delete
% k,delta,        hyperparameters Inverse Wishart
% w,              hyperparameters Bernoulli prior
% v1,             hyperparameter - normal selection prior
%                 (column vector (p by 1) of standard deviations)
% inde,	          Number of independent effects (main effects + sd order)
%
% nDum,           vector whose components give the actual number of
%                 variables in each group.
% pm,             Number of independent main effects
% OUTPUTS:
% r,              log-relative posterior probability of gamma
% Qqr, Rqr,       QR matrices of gamma
%
% USAGE:
% [r, Qqr, Rqr]= ...
% gofg_sp(gamma,indice,X,Ytilde,QqrP,RqrP,elem,k,delta,w,v1);
%
% NOTES:
% Called by bvsgs_sp and itergs_sp
% Function called : complete
%
% REFERENCE:
% Brown, P.J., Vannucci, M. and Fearn, T.
% Multivariate Bayesian variable selection and prediction
% Journal of the Royal Statistical Society B, 60(3), 1998, pp. 627-641.
%
% Delouille,V., Bayesian variable selection with related predictors,
% MSc thesis, University of Kent at Canterbury, UK, 1998.
%
%Copyright (c) 1997 Marina Vannucci.
%Modified by Veronique Delouille 1998
%**********************************************************************
ind1=indice;
[nOss p]=size(X);
[q]=size(Ytilde,2);
Qk=k*eye(q);
gamfull=full(gamma);
[gamc]=Complete(gamma,inde,nDum,pm); %----gamc is the 'complete' gamma
I=find(gamc);
nonnulle=length(I);
if elem > inde
indice = 1;
end;
switch indice
        case 1  % ------------------ Indice = 1 -- QR Decomposition
		sotto=zeros(p,nonnulle);
		sotto(I,:)=eye(nonnulle);
			% Augmented X, (nOss+p) by nonnulle, 
			% H0=Diag*R*Diag,R=Id
		Xtilde=cat(1,X(:,I)*diag(v1(I)), sotto); 
		size(Xtilde) 	;	
		[Qqr Rqr]=qr(Xtilde);    


        case 2  % ------------------ Indice = 2 -- QRinsert
		prima=find(I<elem);
		jj=length(prima)+1;
		sotto=zeros(p,1);
		sotto(elem)=1;
		ins=cat(1, X(:,elem)*v1(elem), sotto);
		[Qqr Rqr]=qrinsert(QqrP,RqrP,jj,ins);

                                
        case 3  % ------------------ Indice = 3 -- QRdelete
		prima=find(I<elem);
		jj=length(prima)+1;
		[Qqr Rqr]=qrdelete(QqrP,RqrP,jj);      
end
sizQr=size(Qqr(:,nonnulle+1:nOss+p)');
sizYtil=size(Ytilde);
sub=Qqr(:,nonnulle+1:nOss+p)'*Ytilde;	% Seber, page 498
RSP=sub'*sub;                       	% residual sum of products
Qstar=Qk+RSP;                       	% q by q
switch nonnulle
	case 1
        	detH0K=Rqr(1,1)^2;
	otherwise
        	detH0K=prod(diag(Rqr).^2);
end
prog = prior(w,gamma,inde,pm,length(nDum));
r= -(q/2)*log(detH0K) - ((delta+nOss+q-1)/2)*log(det(Qstar)) + prog;
