function [gamnew, probnew, QqrN, RqrN, swit]= ...
itergs_sp(gamprec,probprec,X,Ytilde,QqrP,RqrP,k,delta,w,v1,inde,nDum,pm);

%itergs_sp: Gibbs Sampler - Selection prior - Single iteration
%*******************************************************************
%INPUTS:
% gamprec,        previous binary vector.
% probprec,       log-relative posterior probability of gamprec
% X,              independent variables, n by p
% Ytilde,         augmented response matrix, (n+p) by q
% QqrP,RqrP,      QR-matrices for gamprec
% k,delta,        hyperparameters Inverse Wishart
% w,              hyperparameters Bernoulli prior
% v1,             hyperparameter - normal selection prior
%                 (column vector (p by 1) of standard deviations)
% inde,           number of independent effects (main effects + sd
%                 order terms)
% nDum,           vector whose components give the actual number of
%                 variables in each group.
% pm,             number of independent main effects
%
%OUTPUTS:
% gamnew,         new visited vector
% probnew,        log-relative posterior probability of gamnew
% QqrN, RqrN,	  QR-matrices for gamnew
% swit,           number of component switches (out of p) 
%		  for this iteration
%
%USAGE:
% [gamnew, probnew, QqrN, RqrN, swit]= ...
% itergs_sp(gamprec,probprec,X,Ytilde,QqrP,RqrP,k,delta,w,v1);
%
%NOTES:
% One iteration consists of pg Bernoulli draws.
% Called by gibbs_sp
% Functions called: bernoulli.m, gofg_sp.m
%
%REFERENCE:
% Brown, P.J., Vannucci, M. and Fearn, T.
% Multivariate Bayesian variable selection and prediction
% Journal of the Royal Statistical Society B, 60(3), 1998, pp. 627-641.
%
% Delouille,V., Bayesian variable selection with related predictors,
% MSc thesis, University of Kent at Canterbury, UK, 1998.
%
%Copyright (c) 1997 Marina Vannucci.
%Modified by Veronique Delouille 1998
%**********************************************************************

[nOss p]=size(X);
[q]=size(Ytilde,2);
[pg] = size(gamprec,2);
                % pg independent variables, q responses, nOss observations
swit=0;
%-------------------sampling from the full conditionals of single elements
for j=1:pg
	switch gamprec(j)

%---------------case previous j-th element equal 0
		case 0
			probzero=probprec;
			gamtmp=gamprec;
			gamtmp(j)=1;
			[probone, Qqrtmp, Rqrtmp]= ...
gofg_sp(gamtmp,2,X,Ytilde,QqrP,RqrP,j,k,delta,w,v1,inde,nDum,pm); 

%---------------sampling from the Bernoulli distribution
			teta=1/(exp(probzero-probone)+1);
                	gamprec(j)=bernoulli(teta);
                        
%---------------updating posterior probability for the next component 
                	if gamprec(j)==1
                        	probprec=probone;     
                                QqrP=Qqrtmp;
                                RqrP=Rqrtmp;
				swit=swit+1;
			else
                        end
 
%---------------case previous j-th element equal 1
		otherwise
			probone=probprec;
			gamtmp=gamprec;
                        gamtmp(j)=0;
			[probzero, Qqrtmp, Rqrtmp]= ...
gofg_sp(gamtmp,3,X,Ytilde,QqrP,RqrP,j,k,delta,w,v1,inde,nDum,pm);
                
%---------------sampling from the Bernoulli distribution                        
                        teta=1/(exp(probzero-probone)+1);
                        gamprec(j)=bernoulli(teta);

%---------------updating posterior probability for the next component
                        if gamprec(j)==0
                                probprec=probzero;
                                QqrP=Qqrtmp;
                                RqrP=Rqrtmp;
				swit=swit+1;
                        else
			end
	end	
end
gamnew=gamprec;
probnew=probprec;
QqrN=QqrP;
RqrN=RqrP;
