function prog=prior(w,gamma,inde,pm,lnDum)
% prior : computes log-prior for gamma
%*************************************
% INPUTS
%w,      Bernoulli prior. If the strong heredity principle is
%        adopted, w=[wm p11 eta wmD p11D], where
%        wm = hyperparameter Bernoulli prior for independent main effects
%        p11 = p(ga_jk=1|ga_j=ga_k=1), when X_j and X_k are independent (j=k
%        for a quadratic term)
%        eta= p(ga_jk=1|ga_j = 0 or ga_k=0) (typically eta=0.00001)
%        wnD = prior probability of a group of variable to be active
%        p11D = p(ga_jk=1|ga_j=ga_k=1) when j or k are a group of variable.
%
%        If the weak heredity principle is preferred,
%        w = [wm, p11, p10, p00, wmD, p11D p10D], with
%        wm = hyperparameter Bernoulli prior for independent main effects
%        p11 = p(ga_ik =1|ga_i=1,ga_k=1) for i,k independent effects;
%        p10 = p(ga_ik=1|ga_i=0,ga_k=1)=p(ga_ik=1|ga_i=1,ga_k=0) for i,k
%        independent effects;
%        p00 = p(ga_ik=1|ga_i=0, ga_k=0)for independent effect or when i or k
%        is a group of variables (typically p00=0.00001)
%        wmD = prior probability of a group of variable to be active
%        p11D= p(ga_ik =1|ga_i=1,ga_k=1) when i or k is a group of
%        variables
%        p10D = p(ga_ik=1|ga_i=0,ga_k=1)=p(ga_ik=1|ga_i=1,ga_k=0) when i or k   
%        is a group of variables.
%gamma,  reduced version of gamma
%inde,	number of independent main effects
%
% OUTPUT
%       prog,   log-prior of gamma (strong heredity assumption).
%
% NOTES:
% Called by gofg
% Functions called: priorstr, priorweak
%
%REFERENCE:
% Delouille,V., Bayesian variable selection with related predictors,
% MSc thesis, University of Kent at Canterbury, UK, 1998.
%
% Copyright (c) 1998 Veronique Delouille
%******************************************************************

lw=length(w);
switch lw
case 5
% Case of strong heredity assumption
prog=priorstr(w,gamma,inde,pm,lnDum);

case 7
% Case of weak heredity assumption
prog=priorweak(w,gamma,inde,pm,lnDum);
end
