function [progst]=priorstr(w,gamma,inde,pm,lnDum);
%priorstr: computes log-prior for gamma in the case of strong heredity
%          assumption
%*********************************************************************
% INPUTS
%w,	 w=[wm p11 eta wmD p11D], where
%        wm = hyperparameter Bernoulli prior for independent main effects
%        p11 = p(ga_jk=1|ga_j=ga_k=1), when X_j and X_k are independent (j=k    
%        for a quadratic term)
%        eta= p(ga_jk=1|ga_j = 0 or ga_k=0) (typically eta=0.00001) 
%        wnD = prior probability of a group of variable to be active
%        p11D = p(ga_jk=1|ga_j=ga_k=1) when j or k are a group of variable.
%
%inde,	 number of independent effects
%lnDum,  number of groups of variables
%
%OUTPUT
%prog,	log-prior of gamma (strong heredity assumption).
%
% NOTES:
% Called by prior.
% Functions called: priorgam, priorstrD
%        
%REFERENCE:
% Delouille,V., Bayesian variable selection with related predictors,
% MSc thesis, University of Kent at Canterbury, UK, 1998.
%        
% Copyright (c) 1998 Veronique Delouille
%********************************************************************* 

ltot=size(gamma,2);
% Separate quantitative and dummy variable

gamQ=gamma(1:inde);%'independent' effects.
gamD=gamma(inde+1: ltot);% grouped (often dummy) variables.

% Work out separately quantitative and grouped variables.
wQ=w(1:3);
prog1=priorgam(gamQ,wQ,pm);
prog2=priorstrD(gamD,gamQ(1:pm),w,lnDum);

progst=prog1+prog2;

