function [progst]=priorstrD(gamD,gamQm,w,lnDum);
% priorstrD : computes log-prior for the components of gamma involving
%             groups of variables (main effects and interaction with
%             an independent effect)--strong heredity assumption
%*********************************************************************
% INPUT: 
%	gamD,	vector gamma for grouped (often Dummy) variables
%	gamQm,	vector gamma for quantitative main effects	
%	w,	Bernoulli prior
%	lnDum,	number of distinct group of variable.
%
% OUTPUT
%	prog,	log-prior of gamma for dummy variable (strong heredity
% 	assumption).
%
% REFERENCE:
% Delouille,V., Bayesian variable selection with related predictors,
% MSc thesis, University of Kent at Canterbury, UK, 1998.
%
% Copyright (c) 1998 Veronique Delouille
%*********************************************************************

eta = w(3);
wm=w(4);
pr=w(5);

ltot=size(gamD,2);
% Separate main effects and interactions

gamD1=gamD(1:lnDum);
gamD2=gamD(lnDum+1: ltot);


%----Compute prior for main effects -- dummy variable.
prog1=sum(log((wm.^gamD1).*(1-wm).^(1-gamD1)));

%----Compute prior for 2nd order terms
gprod = kron(gamD1,gamQm); %----products gD1.gX1,gD1.gX2,...
g12pr=gamD2.*gprod;
g12npr=(1-gamD2).*gprod;
g12prn=gamD2.*(1-gprod);
g12nprn=(1-gamD2).*(1-gprod);
prog2=sum(log((pr.^g12pr).*((1-pr).^g12npr).*(eta.^g12prn).*...
((1-eta).^g12nprn)));

progst=prog1 +prog2;

