function [progwe] = priorweD(gamD,gamQm,w,lnDum)
% priorweD:computes log-prior for the components of gamma involving
%          groups of variables (main effects and interaction with an
%          independent effect)--weak heredity assumptions
%*******************************************************************
% INPUTS
% gamD,   gamma for grouped (often Dummy) variables
% gamQm,  gamma for main effects --- quantit.variables
% w,      Bernoulli prior, p00 =w(4), wm=w(5); p11=w(6), p10=w(7)
% lnDum,  number of groups of variables
%
% OUTPUT :
% progwe, log-prior for gamma for components involving a group of
%         variables (weak heredity assumptions)
%
% NOTES :
% Function called : gamsumD
%
% REFERENCE:
% Delouille,V., Bayesian variable selection with related predictors,
% MSc thesis, University of Kent at Canterbury, UK, 1998.
%
% Copyright (c) 1998 Veronique Delouille
%*******************************************************************

p00 =w(4);
wm = w(5); 
p11=w(6);
p10=w(7);

ltot=size(gamD,2);
% Separate main effects and interactions

gamD1=gamD(1:lnDum);
gamD2=gamD(lnDum+1: ltot);


%----Compute prior for main effects -- dummy variable.
prog1=sum(log((wm.^gamD1).*(1-wm).^(1-gamD1)));

%----Compute prior for 2nd order terms
gprod = kron(gamD1,gamQm); %----products gD1.gX1,gD1.gX2,...
gsum=gamsumD(gamD1,gamQm,lnDum);% produce a vector [gX1
%				 +gD1,gX2+gD1,...]
exp00=1-gsum+gprod;
exp10=gsum - 2*gprod;
g00=gamD2.*(exp00); 
g10=gamD2.*(exp10);
g11=gamD2.*gprod;
gn00=(1-gamD2).*exp00;
gn10=(1-gamD2).*exp10;
gn11=(1-gamD2).*gprod;
prog2=sum(log((p00.^g00).*(p10.^g10).*(p11.^g11).*((1-p00).^gn00).*((1-p10).^gn10).* ((1-p11).^gn11)));
progwe=prog1+prog2;


