function [progwe]=priorweak(w,gamma,inde,pm,lnDum);
% priorweak : computes log-prior for gamma in the case of weak heredity
%             assumptions
%*********************************************************************
%INPUTS
%w,  	 Bernoulli prior :w = [wm, p11, p10, p00, wmD, p11D,p10D], where
%        wm = hyperparameter Bernoulli prior for independent main effects
%	 p11 = p(ga_ik =1|ga_i=1,ga_k=1) for i,k independent effects;
%        p10 = p(ga_ik=1|ga_i=0,ga_k=1)=p(ga_ik=1|ga_i=1,ga_k=0) for i,k
%        independent effects;
%        p00 = p(ga_ik=1|ga_i=0, ga_k=0)for independent effect or when i or k
%        is a group of variables (typically p00=0.00001)
%        wmD = prior probability of a group of variable to be active
%        p11D= p(ga_ik =1|ga_i=1,ga_k=1) when i or k is a group of
%        variables
%        p10D = p(ga_ik=1|ga_i=0,ga_k=1)=p(ga_ik=1|ga_i=1,ga_k=0) when i or k
%        is a group of variables.
%gamma,	 reduced version of the latent vector
%inde,   number of independent effects (main effects +sd order terms)
%pm,     number of independent main effects
%lnDum,  number of groups of variables
%
%OUTPUT
%	prog,	log-prior of gamma (strong heredity assumption).
%
%NOTE:
% Called by prior
%Functions called: priorweme, priorweD
%
%REFERENCE:
% Delouille,V., Bayesian variable selection with related predictors,
% MSc thesis, University of Kent at Canterbury, UK, 1998.
%        
% Copyright (c) 1998 Veronique Delouille
%****************************************************************** 

ltot=size(gamma,2);
% Separate quantitative and dummy variable
gamQ=gamma(1:inde);%'independent' effects.
gamD=gamma(inde+1: ltot);% grouped (often Dummy) variables.

% Work out separately quantitative and grouped variables.
wQ=w(1:4);
prog1=priorweme(gamQ,wQ,pm);
prog2=priorweD(gamD,gamQ(1:pm),w,lnDum);

progwe=prog1+prog2;

