function [GammaO, logProbO, PostGam, MargGam]=...
probord(logProb,Gamma,inde,nDum,pm)
 
%probord:  Bayesian Variable Selection
%          Normalized posterior probs, marginal probs and    
%          ordering of distinct visited vectors according
%          to probability
%***********************************************************************
%INPUTS:
% logProb,              log-relative post probs of visited vectors
% Gamma,                matrix - distinct visited vectors
% inde,                 number of independent effects (main effects + sd
%                       order terms)
% nDum,                 vector whose components give the actual number of
%                       variables in each group.
% pm,                   number of independent main effects
%
%OUTPUTS:
% GammaO,               matrix - distinct visited vectors
%                       ordered according to PostGam
% logProbO,             log-relative post probs of visited vectors
%                       (ordered)
% PostGam,              normalized posterior probs of visited vectors
%                       (ordered)
% MargGam,              marginal probs
%
%USAGE:
% [GammaO, logProbO, PostGam, MargGam]=probord(logProb, Gamma)
%
%Copyright (c) 1997 Marina Vannucci.
%Modified by Veronique Delouille 1998
%**********************************************************************

%----------------------- normalized posterior probs
media=mean(logProb);
PostGam=exp(logProb-media);
den=sum(PostGam);
PostGam=PostGam/den;

%----------------------- marginal probs
Gamc=Complete(Gamma,inde,nDum,pm);
MargGam=(PostGam*Gamc);       

%------------------ Ordering of rows of Gamma according to PostGam
%		    (descending order)

[PostGam ordine]=sort(PostGam);
ordine=rot90(ordine);
PostGam=rot90(PostGam);
GammaO=Gamma(ordine,:);
logProbO=logProb(ordine);

