function [DX] = process_gi(Xpm,dataD,nDum)
% process_gi : pre-processing of the data: construction of interaction
%              between grouped variables and independent main effects
%*********************************************************************
% INPUTS
%	Xpm,	matrix with main effects of independent variables, 
%               the data must be centered.
%	dataD,	main effects of the variables that are grouped, also 
%               centered.
%	nDum,	number of variables in each group (the order of the
%               groups in nDum must correspond to the order in dataD).
%
% OUTPUT
%	DX,	matrix containing the main effects of grouped variables
%        	and the centered interactions between grouped variables
%               and independent main effects.
%
%Copyright (c) 1998 Veronique Delouille
%**********************************************************************
snDum=sum(nDum);
lnDum=length(nDum);
Dconst=dataD;
[noss,pm]=size(Xpm); %Full size
%---- Construction of Interactions
base=0;
for i =1:lnDum
col=dataD(:,base+1 :base+ nDum(i));
	for j=1:pm
	Xj=Xpm(:,j);
        Ximat=Xj*ones(1,nDum(i));
	Dj=col.*Ximat;
	Dconst=cat(2,Dconst,Dj);
end;
base=base+nDum(i);
end;

% -- Centering of the interaction terms
%
tot=size(Dconst,2);
XDint=Dconst(:,snDum+1:tot);
m=mean(XDint);

Mcal=ones(noss,1)*m;
DXin = XDint - Mcal;
DX=cat(2,dataD,DXin);
