function [Y,X,pm1,combin]=processing(nbresp,YX)
% processing: pre-processing of the data
%*********************************************************************
% INPUTS : 
% nbresp,   number of response variables.
% YX,       matrix of raw data, with in the first 'nbresp' columns the
%           response  variables Y and in 
%           other columns the independent predictors (main effects)
% 
% OUTPUTS: 
% Y,        matrix of centered response variables;
% X,        matrix of regressors where the main effects have been
%           centered; and the quadratic and 2-way interactions
%           terms have been added.
% pm1,      number of main effects;
% combin,   contains the link between index of the variables and the
%           corresponding main effect or interaction term.
%
% Copyright (c) 1998 Veronique Delouille
%**********************************************************************
[noss,z]=size(YX);nbresp=1;
pm=z-nbresp;

%--------------------Centering of data
m=mean(YX);%m:1xpm
M=ones(noss,1)*m;
YXc=YX-M;

Y=YXc(:,1:nbresp);
Xm=YXc(:,(nbresp+1):z);

%----------Quadratic and Interaction terms
combi=comb(pm,2);

combi=zeros(2,combi);
count=0;
Xconst=Xm;
tool=ones(noss,1);

for i=1:pm
combi(1,(count+1):(count+pm-i+1))=i*ones(1,pm-i+1);
combi(2,(count+1):(count+pm-i+1))=(1:pm-i+1)+(i-1);
count=count+pm-i+1;
Xi=Xm(:,i);
tool2=ones(1,pm-i+1);
XXi=(Xi*tool2);
Xadd=XXi.*Xm(:,i:pm);
Xconst=cat(2,Xconst,Xadd);
end;
Main=cat(1,1:pm,zeros(1,pm));
combi=cat(2,Main,combi);
m=mean(Xconst);
X=Xconst - ones(noss,1)*m; % X contains now the full matrix of regressors
pm1=pm;
combin=combi;
