function [gsum]=gamsum(gam1,l);
% gamprod : sums of components of gamma related to main effects
%******************************************************************
% INPUTS : gam1: vector gamma of main effects
%          l : length of complete vector gamma
% OUTPUT : gsum : vector of length (l-(nbr of main effects)) containing
%          the sums ga_1+ga_1, ga_1+ga_2, ....
% REFERENCE:
% Delouille,V., Bayesian variable selection with related predictors,
% MSc thesis, University of Kent at Canterbury, UK, 1998.
%
% Copyright (c) 1998 Veronique Delouille
%*******************************************************************
pm=length(gam1);
lprod=l-pm;
gams=zeros(2,lprod);
G=gam1'*ones(1,pm);
lold=0; lnew=0;
for i =1: pm
	longi=gam1(i:pm);
	lnew=pm -i+1 +lold;
	gams(1,(lold+1):lnew)=longi;
	gams(2,(lold+1):lnew)=G(i,i:pm);
	lold=lnew;
end
gsum=gams(1,:)+gams(2,:);
