function [ProbSt, GammaSt, storeS]= ... 
gibbs_sp(gamprec,probprec,X,Ytilde,QqrP,RqrP,k,delta,w,v1,nPar,pm);

%gibbs_sp: Gibbs Sampler - Selection prior - nPar iterations
%*******************************************************************
%INPUTS:
% gamprec,        initial binary vector.
% probprec,	  log-relative posterior probability of gamprec
% X,              independent variables, n by p
% Ytilde,         augmented response matrix, (n+p) by q
% QqrP,RqrP,	  QR-matrices for gamprec
% k,delta,        hyperparameters Inverse Wishart
% w,              hyperparameter Bernoulli priors
% v1,  		  hyperparameter - normal selection prior
%                 (column vector (p by 1) of standard deviations)   
% nPar,           number of iterations
% pm,		  number of independent main effects
%
%OUTPUTS:
% ProbSt,	  log-relative posterior probabilities
%                 of visited vectors
% GammaSt,        visited vectors
% storeS, 	  number of component switches (out of p) from iteration
%                 to iteration.
%
%USAGE:
% [ProbSt, GammaSt, storeS]= ... 
% gibbs_sp(gamprec,probprec,X,Ytilde,QqrP,RqrP,k,delta,w,v1,nPar);
%
%NOTES:
% One iteration consists of p Bernoulli draws (function itergs_sp.m)
% Called by bvsgs_sp
% Functions called: itergs_sp.m
% 
%REFERENCE:
% Brown, P.J., Vannucci, M. and Fearn, T.
% Multivariate Bayesian variable selection and prediction
% Journal of the Royal Statistical Society B, 60(3), 1998, pp. 627-641.
%
% Delouille,V., Bayesian variable selection with related predictors,
% MSc thesis, University of Kent at Canterbury, UK, 1998.
%       
%Copyright (c) 1997 Marina Vannucci.
%Modified by Veronique Delouille 1998.
%**********************************************************************

p=size(X,2);
storeS=zeros(1,nPar);
GammaSt=sparse(zeros(nPar,p));
ProbSt=zeros(1,nPar);

for i=1:nPar

%------------------- One iteration consists of p Bernoulli draws 
%				(function itergs_sp.m)

	[gamprec, probprec, QqrN, RqrN, swit] = ...
	itergs_sp(gamprec,probprec,X,Ytilde,QqrP,RqrP,k,delta,w,v1,pm);
	QqrP=QqrN;
	RqrP=RqrN;
	GammaSt(i,:)=gamprec;
	ProbSt(i)=probprec;
	storeS(i)=swit;
end
