function [prog]=prior(gamma,w,pm);
%prior: Function that computes the log-prior probability of gamma
%*********************************************************************
%INPUTS:
%gamma,   binary vector
%pm,      number of main effect
%w,       hyperparameters Bernoulli prior
%
%OUTPUT:
%prog,    logprior of gamma
%
%NOTES:
% Functions called: priorgam, priorweak
% This program checks if gamma is structured through the weak or strong
% heredity principle and calls the appropriate function.
%
%Copyright (c) 1998 Veronique Delouille.
%***********************************************************************
lw=length(w);

% ---- See if gamma is structured through the weak or strong
% ---- heredity principle

switch lw
	case 3 %---- Strong heredity principle assumed
	prog=priorgam(gamma,w,pm);

	case 4 %---- Weak heredity principle assumed
	prog=priorweak(gamma,w,pm);
end
