function [prog]=priorgam(gamma, w, pm)
%priorgam: Function that computes the log-prior probability of gamma,
%          Strong heredity principle.
%********************************************************************
%INPUTS 
%gamma,		binary vector
%pm,		number of main effects
%w,             w=[wm  pr  eta], with
%               wm  = hyperparameter Bernoulli prior for main effects
%               pr  = p(ga_jk=1|ga_j=ga_k=1)(j may be equal to k)
%               eta = p(ga_jk=1|ga_j = 0 or ga_k=0)
%
%OUTPUT 
%prog,		log-prior of gamma
%
%NOTES:
% Functions called: gamprod
%
%REFERENCE:
% Delouille,V., Bayesian variable selection with related predictors,
% MSc thesis, University of Kent at Canterbury, UK, 1998,
%
%Copyright (c) 1998 Veronique Delouille.
%*********************************************************************
wm=w(1);pr=w(2);eta=w(3);
l=length(gamma);
gam1=gamma(1:pm);
gam2=gamma(pm+1:l);

%Compute prior for main effects
prog1=sum(log((wm.^gam1).*(1-wm).^(1-gam1)));

%Compute prior for 2nd order terms
gprod = gamprod(gam1,l);
g12pr=gam2.*gprod;
g12npr=(1-gam2).*gprod;
g12prn=gam2.*(1-gprod);
g12nprn=(1-gam2).*(1-gprod);
prog2=sum(log((pr.^g12pr).*((1-pr).^g12npr).*(eta.^g12prn).*((1-eta).^g12nprn)));
prog=prog1+prog2;

