function [prog]=priorweak(gamma, w, pm);
% priorweak:Function that computes the log-prior probability of gamma,
%           Weak heredity principle.
%********************************************************************
% INPUTS: gamma: binary vector
%         pm : number of main effects
%         w=[wm, p11, p10, p00], with
%         wm : hyperparameter Bernoulli prior for main effects
%         p11 = p(ga_ik =1|ga_i=1,ga_k=1);
%         p10 = p(ga_ik=1|ga_i=0,ga_k=1)=p(ga_ik=1|ga_i=1,ga_k=0);
%         p00 = p(ga_ik=1|ga_i=0, ga_k=0);
%
% OUTPUTS prog : logprior of gamma 
%
% NOTES :
% Functions called: gamprod, gamsum
%
%REFERENCE:
% Delouille,V., Bayesian variable selection with related predictors,
% MSc thesis, University of Kent at Canterbury, UK, 1998,
%
%Copyright (c) 1998 Veronique Delouille.
%*********************************************************************
wm = w(1);
p11=w(2);
p10=w(3);
p00=w(4);
longeur=length(gamma);
gam1=gamma(1:pm);
gam2=gamma(pm+1:longeur);
%
%--------------------Compute prior for main effects---------------------
%----------------------------------------------------------------------- 
%
prog1=sum(log((wm.^gam1).*(1-wm).^(1-gam1)));

%
%--------------------Compute prior for 2nd order terms------------------
%-----------------------------------------------------------------------
%
gprod=gamprod(gam1,longeur);
gsum=gamsum(gam1,longeur);% produce a vector[ga_1+ga_1,ga_1+ga_2,ga_1+ga_3,...]
exp00=1-gsum+gprod;
exp10=gsum - 2*gprod;
g00=gam2.*(exp00);
g10=gam2.*(exp10);
g11=gam2.*gprod;
gn00=(1-gam2).*exp00;
gn10=(1-gam2).*exp10;
gn11=(1-gam2).*gprod;
pr0=(p00.^g00).*(p10.^g10).*(p11.^g11);
pr1=((1-p00).^gn00).*((1-p10).^gn10).* ((1-p11).^gn11);
prog2=sum(log(pr0.*pr1));
prog=prog1+prog2;

