function [Gnew, Pnew]=repliche(G, P);

%repliche: Bayesian Variable Selection 
%	   Search for replicates
%***********************************************************************
%INPUTS:
% G,		matrix - visited vectors
% P,		vector - log-relative post probs of visited vectors
%
%OUTPUTS:
% Gnew,		matrix G without replicates
% Pnew,		log-relative post probs of vectors in Gnew
% 
%USAGE:
% [Gnew, Pnew]=repliche(G, P);
%
%NOTE:
% May be slow with very large matrices
%
%Copyright (c) 1997 Marina Vannucci.
%**********************************************************************
 
switch class(G)
	case 'sparse'
		G=full(G);	% unique.m does not work with sparse matrices
		[Gnew,I,J]=unique(G,'rows');
		Pnew=P(I);
  	        Gnew = sparse(Gnew);
	otherwise
		[Gnew,I,J]=unique(G,'rows');                
		Pnew=P(I);
end	
