## Copyright (C) 2009  Roberto Bertolusso, Marek Kimmel
##
## This library is free software; you can redistribute it and/or
## modify it under the terms of the GNU Library General Public
## License as published by the Free Software Foundation; either
## version 3 of the License, or (at your option) any later version.
##
## This library is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
## Library General Public License for more details.
##
## You should have received a copy of the GNU Library General Public
## License along with this library; if not, a copy is available at
## http://www.r-project.org/Licenses/

rb.gillespie <- function(model, steps) {
  pre <- model$pre
  post <- model$post
  h <- model$h
  M <- model$M
  storage.mode(pre) <- storage.mode(post) <-
    storage.mode(M) <- storage.mode(steps) <- "integer"
  storage.mode(h) <- "double"

  .Call("rb_gillespie", pre, post, h, M, steps)
}

GillespieOptimDirect <- function(model, timep, delta=1, runs=1) {
  pre <- model$pre
  post <- model$post
  h <- model$h
  M <- model$M

  storage.mode(pre) <- storage.mode(post) <- storage.mode(runs) <- "integer"
  storage.mode(delta) <- storage.mode(M) <- "double"

  if (is.null(place <- model$place)) {
    place <- paste("P",1:ncol(pre),sep="")
  }
  if (is.null(transition <- model$transition)) {
    transition <- paste("T",1:nrow(pre),sep="")
  }

  .Call("GillespieOptimDirect", pre, post, h, M, timep, delta, runs, place, transition, parent.frame())
}

rb.gillespie.orig <- function(model, steps) {
  pre <- model$pre
  post <- model$post
  h <- model$h
  M <- model$M

  storage.mode(pre) <- storage.mode(post) <-
    storage.mode(M) <- storage.mode(steps) <- "integer"
  storage.mode(h) <- "double"

  .Call("rb_gillespie_orig", pre, post, h, M, steps)
}

rb.gillespie.d.orig <- function(model, timep, delta) {
  pre <- model$pre
  post <- model$post
  h <- model$h
  M <- model$M

  storage.mode(pre) <- storage.mode(post) <- storage.mode(M) <- "integer"
  storage.mode(h) <- storage.mode(T) <- storage.mode(delta) <- "double"

  .Call("rb_gillespie_d_orig", pre, post, h, M, timep, delta)
}
