## Copyright (C) 2009  Roberto Bertolusso, Marek Kimmel
##
## This library is free software; you can redistribute it and/or
## modify it under the terms of the GNU Library General Public
## License as published by the Free Software Foundation; either
## version 3 of the License, or (at your option) any later version.
##
## This library is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
## Library General Public License for more details.
##
## You should have received a copy of the GNU Library General Public
## License along with this library; if not, a copy is available at
## http://www.r-project.org/Licenses/

PartitionedLeaping <- function(model, timep, delta=1 , runs=1, ect=1e-9, burnRnd=0) {
  pre <- model$pre
  post <- model$post
  h <- model$h
  M <- model$M

  storage.mode(pre) <- storage.mode(post) <- storage.mode(runs) <-
    storage.mode(slow) <- storage.mode(burnRnd) <- "integer"
  storage.mode(delta) <- storage.mode(M) <- storage.mode(ect) <- "double"

  if (is.null(place <- model$place)) {
    place <- paste("P",1:ncol(pre),sep="")
  }
  if (is.null(transition <- model$transition)) {
    transition <- paste("T",1:nrow(pre),sep="")
  }

  .Call("PartitionedLeaping", pre, post, h, M, timep, delta, runs, place, transition, ect, burnRnd, parent.frame())
}
