## Copyright (C) 2009  Roberto Bertolusso, Marek Kimmel
##
## This library is free software; you can redistribute it and/or
## modify it under the terms of the GNU Library General Public
## License as published by the Free Software Foundation; either
## version 3 of the License, or (at your option) any later version.
##
## This library is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
## Library General Public License for more details.
##
## You should have received a copy of the GNU Library General Public
## License along with this library; if not, a copy is available at
## http://www.r-project.org/Licenses/

RungeKuttaDormandPrince45 <- function(model, timep, delta=1, ect=1e-9) {
  model$slow=rep(0,dim(model$pre)[1])

   return(HaseltineRawlings(model, timep, delta, runs=1, ect=1e-9))
##  .Call("rb_rungeKuttaDormandPrince45", pre, post, h, M, T, dt, vpos, vneg, ect, parent.frame())
}

rb.rungeKuttaDormandPrince45.eq <- function(fct, M, timep, dt, ect=1e-9) {
  storage.mode(T) <- storage.mode(dt) <- 
    storage.mode(M) <- storage.mode(ect) <- "double"

  .Call("rb_rungeKuttaDormandPrince45_eq", fct, M, timep, dt, ect, parent.frame())
}
